// SLIDER
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;
	
	// values
	self.Minimum = 0;
	self.Maximum = 100;
	self.Value = 0;
	self.MaximumVisible = -1;
	
	// bar.
	self.Vertical = true;
	self.BarSize = 64;
	self.BarPos = 0;
	
	// dragging.
	self.DragInfo = {
		dragging = false,
		barstart = 0,
		dragstart = 0,
	};
	
end

// set range
function PANEL:SetRange( mins, maxs, visible )
	self.Minimum = mins;
	self.Maximum = maxs;
	self.MaximumVisible = visible or -1;
	
	// clamp value
	self.Value = math.Clamp( self.Value, mins, maxs );
	
	// calc height
	self:CalculateBarSize();
	
end

// set value
function PANEL:SetValue( v )
	// 
	self.Value = v;
	
	// clamp
	self.Value = math.Clamp( self.Value, self.Minimum, self.Maximum );
	
	// update bar.
	self:CalculatePosFromValue();
	
	// call event.
	self:GetParent():ScrollValueChanged( self.Value );
	
end

// get value
function PANEL:GetValue( )
	return self.Value;
	
end

// set horizontal
function PANEL:SetHorizontal( v )
	self.Vertical = !v;
	
end

// perform layout
function PANEL:PerformLayout( )
	// calc height
	self:CalculateBarSize();
	
end

// mouse pressed
function PANEL:OnMousePressed( mc )
	local x, y = gui.MousePos();
	x, y = self:ScreenToLocal( x, y );
	
	// within the bar?
	if( self.Vertical && y > self.BarPos && y < self.BarPos + self.BarSize ) then
		// start drag
		self.DragInfo.dragging = true;
		self.DragInfo.dragstart = y;
		self.DragInfo.barstart = self.BarPos;
	
		// capture the mouse
		self:MouseCapture( true );
		
	elseif( !self.Vertical && x > self.BarPos && x < self.BarPos + self.BarSize ) then
		// start drag
		self.DragInfo.dragging = true;
		self.DragInfo.dragstart = x;
		self.DragInfo.barstart = self.BarPos;
	
		// capture the mouse
		self:MouseCapture( true );
		
	end
	
end

// mouse released
function PANEL:OnMouseReleased( mc )
	// stop the drag
	self.DragInfo.dragging = false;	

	// release the mouse
	self:MouseCapture( false );
	
end


// calculate bar height
function PANEL:CalculateBarSize( )
	// height
	local height = self:GetTall();
	
	// do we have a maxvisible?
	if( self.MaximumVisible != -1 ) then
		// calculate scalar
		local s = self.MaximumVisible / self.Maximum;
		self.BarSize = math.Clamp( height * s, 16, height );
	
	else
		// fixed height
		self.BarSize = 24;
		
	end

end

// calc pos from value
function PANEL:CalculatePosFromValue( )
	// calc size
	local size = self:GetTall();
	if( !self.Vertical ) then size = self:GetWide(); end
	
	// calculate position from value.s
	self.BarPos = ( ( size - self.BarSize ) / ( self.Maximum - self.Minimum ) ) * ( self.Value - self.Minimum );
	
end

// calc value
function PANEL:CalculateValue( )
	// calc size
	local size = self:GetTall();
	if( !self.Vertical ) then size = self:GetWide(); end
	
	// set value
	self.Value = self.Minimum + ( ( self.Maximum - self.Minimum ) / ( size - self.BarSize ) ) * self.BarPos;
	
	// call event
	self:GetParent():ScrollValueChanged( self.Value );
	
end

// mouse moved.
function PANEL:OnCursorMoved( x, y )
	// not dragging?
	if( !self.DragInfo.dragging ) then return; end
	
	// width/height
	local width, height = self:GetSize();
	
	// vertical
	if( self.Vertical ) then
		// calc new pos.
		local y = self.DragInfo.barstart + ( y - self.DragInfo.dragstart );
		
		// clamp.
		if( y > height - self.BarSize ) then y = height - self.BarSize; end
		if( y < 0 ) then y = 0; end
		
		// set pos
		self.BarPos = y;
		
		print( self.BarPos );
	
	// horizontal	
	else
		// calc new pos.
		local x = self.DragInfo.barstart + ( x - self.DragInfo.dragstart );
		
		// clamp.
		if( x > width - self.BarSize ) then x = width - self.BarSize; end
		if( x < 0 ) then x = 0; end
		
		// set pos
		self.BarPos = x;
		
	end
	
	// update
	self:CalculateBarSize();
	self:CalculateValue();
	
end

// paint
function PANEL:Paint( )
	// verticle
	if( self.Vertical ) then
		AppFramework:Theme():DrawFrame( 2, 2 + self.BarPos, 14, self.BarSize - 4, FRAME_OUTSET, "button_face" );
	
	// horizontal
	else
		AppFramework:Theme():DrawFrame( 2 + self.BarPos, 2, self.BarSize - 4, 14, FRAME_OUTSET, "button_face" );
	
	end
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_scrollbar_slider", PANEL, "Panel" );







// SLIDE TRAY
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// scroll up
function PANEL:ScrollUp( )
	// scroll up!
	self.Slider:SetValue( self.Slider:GetValue() - self.ScrollDistance );
	
end

// scroll up
function PANEL:ScrollDown( )
	// scroll up!
	self.Slider:SetValue( self.Slider:GetValue() + self.ScrollDistance );
	
end

// scrollbar.
function PANEL:Init( )
	// linked class.
	self.LinkedClass = nil;
	
	// vertical
	self.Vertical = true;
	self.ScrollDistance = 1;

	// up button
	self.UpButton = CtlButton_class:create( self );
	self.UpButton:SetText( "" );
	self.UpButton:AddEvent( "OnClick", "ScrollUp", self );

	// down button
	self.DownButton = CtlButton_class:create( self );
	self.DownButton:SetText( "" );
	self.UpButton:AddEvent( "OnClick", "ScrollDown", self );
	
	// slider
	self.Slider = vgui.Create( "ctl_scrollbar_slider", self );
	
end

// I really hate this.
function PANEL:ScrollValueChanged( v )
	// call event
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnSliderMoved", self.Slider:GetValue(), self );
		
	end

end

// perform layout
function PANEL:PerformLayout( )
	// width/height
	local width, height = self:GetSize();

	// set up button position. ( always the same for vert or horz haha! )
	self.UpButton:SetPos( 2, 2 );
	
	// vertical
	if( self.Vertical ) then
		// set up button size
		self.UpButton:SetSize( width - 4, width - 4 );
		
		// set down button position and size
		self.DownButton:SetPos( 2, height - 16 );
		self.DownButton:SetSize( width - 4, width - 4 );
		
		// position slider
		self.Slider:SetPos( 0, width - 6 );
		self.Slider:SetSize( 16, height - ( width - 6 ) * 2 );
		
		// updat scroll distance
		self.ScrollDistance = height * 0.1;
		
	// horizontal.
	else
		// set the up button size
		self.UpButton:SetSize( height - 4, height - 4 );
		
		// position the down button.
		self.DownButton:SetPos( width - 16, 2 );
		self.DownButton:SetSize( height - 4, height - 4 );
		
		// position slider
		self.Slider:SetPos( height - 6, 0 );
		self.Slider:SetSize( width - ( height - 6 ) * 2, 16 );
		
		// update scroll distance.
		self.ScrollDistance = width * 0.1;
		
	end
	
end

// set scroll distance
function PANEL:SetScrollDistance( d )
	self.ScrollDistance = d;
	
end

// set horizontal
function PANEL:SetHorizontal( v )
	self.Vertical = !v;
	self.Slider:SetHorizontal( v );
	
end

// paint
function PANEL:Paint( )
	// draw frame.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end

// set range
function PANEL:SetRange( mi, ma, mv )
	self.Slider:SetRange( mi, ma, mv );
	
end

// set value
function PANEL:SetValue( v )
	self.Slider:SetValue( v );
	
end

// get value
function PANEL:GetValue( )
	return self.Slider:GetValue();
	
end

// register
vgui.Register( "ctl_scrollbar", PANEL, "Panel" );



// create app framework control.
CtlScrollBar_class 	= Control_class:create( nil, false, "ctl_scrollbar" );

// set range
function CtlScrollBar_class:SetRange( mi, ma, mv )
	self:GetHandle().Slider:SetRange( mi, ma, mv );
	
end

// set value
function CtlScrollBar_class:SetValue( v )
	self:GetHandle().Slider:SetValue( v );
	
end

// get value
function CtlScrollBar_class:GetValue( )
	return self:GetHandle().Slider:GetValue();
	
end

// set horizontal
function CtlScrollBar_class:SetHorizontal( v )
	self:GetHandle():SetHorizontal( v );
	
end
